__PureConfig_version = 1.84


function _d(v)
    ac.debug("---",v)
    return v
end

__pureConfig_path = ac.dirname()

function ___reset__PureConfig___(msg)
    msg = msg or "___reset__PureConfig___"
    file_write(__pureConfig_path.."\\reset_dummy.lua","w+", msg)
end

-- get CSP version
__CSP_version = 0
if ac['getPatchVersionCode'] ~= nil then __CSP_version = ac.getPatchVersionCode() end


___PURE___dev_version = true

function dev_dbg(msg, value)
    if ___PURE___dev_version then
        ac.debug(msg, value)
    end
end

local gcSmooth = 0
local gcRuns = 0
local gcLast = 0
local function runGC()
    local before = collectgarbage('count')
    collectgarbage()
    gcSmooth = math.applyLag(gcSmooth, before - collectgarbage('count'), gcRuns < 50 and 0.9 or 0.995, 0.05)
    gcRuns = gcRuns + 1
    gcLast = math.floor(gcSmooth * 100) / 100
end

local function printGC()
ac.debug("Runtime | collectgarbage", gcLast .. " KB")
end


function get__dirname()
    if ac.dirname then
        return ac.dirname()
    else
        return "assettocorsa\\extension\\weather\\pure"
    end
end



local wfx = ac.INIConfig.cspModule(ac.CSPModuleID.WeatherFX)
local style = wfx:get("BASIC","IMPLEMENTATION", "")
local style_path = "pure"
local style_mode = 0

-- check which wfx is running
function get_style()
    wfx = ac.INIConfig.cspModule(ac.CSPModuleID.WeatherFX)
    style = wfx:get("BASIC","IMPLEMENTATION", "")

    if style == "Pure LCS" then
        style_path = "Pure LCS"
        style_mode = 2
    elseif style == "pure" then
        style_mode = 1
    end

    return style
end
get_style()

ac.onCSPConfigChanged(ac.CSPModuleID.WeatherFX, function()
    local tmp_wfx = ac.INIConfig.cspModule(ac.CSPModuleID.WeatherFX)
    local tmp_style = tmp_wfx:get("BASIC","IMPLEMENTATION", "")
    if tmp_style~=style then
        ___reset__PureConfig___("wfx changed")
    end
end)




local _l_config_path = ac.getFolder(ac.FolderID.ExtRoot).."\\config-ext\\"..style_path.."\\"
__pure_path = __pureConfig_path.."\\..\\..\\..\\extension\\weather\\pure"

-- fast Lookup tables
dofile(__pure_path.."\\utils\\utils_LUT.lua")
dofile(__pure_path.."\\utils\\utils_basics.lua")

dofile(__pure_path.."\\utils\\utils_memory_backup.lua")
dofile(__pure_path.."\\utils\\utils_connect.lua")
dofile(__pure_path.."\\utils\\utils_state.lua")
dofile(__pure_path.."\\utils\\utils_json.lua")
dofile(__pure_path.."\\utils\\config_ini_parser.lua")

dofile(__pure_path.."\\ui\\Pure_UI.lua")
dofile(__pure_path.."\\ui\\Pure_UI__FileDialog.lua")

dofile(__pureConfig_path.."\\UI\\gl.lua")

dofile(__pureConfig_path.."\\utils\\fix_settings.lua")
dofile(__pureConfig_path.."\\utils\\groundfog.lua")

dofile(__pureConfig_path.."\\UI\\ConfigInfo.lua")
dofile(__pureConfig_path.."\\UI\\ConfigDesign.lua")

-- Pure sends a signal if it runs
_l_PURE_PILOT_TONE = RAMBackup("PURE_PILOT_TONE")
_l_PURE_PILOT_TONE_update = os.clock()

local pureConnect = Connect("PureConfig", nil, true, __PureConfig_version)
local pureConnectRoot = Connect("PureConfigRoot", nil, true, __PureConfig_version, "PureConfig")
local pureConnectTrack = Connect("PureConfig_Track_Adaptions", nil, true, __PureConfig_version)
--pureCustomScriptConnect = Connect("PureScriptSettings", nil, true, __PureConfig_version)
local pureConfigUI = PureUI(pureConnect, "PureConfig")
pureConfigUI:setDesign(createPureNotSelectedUI, true)

local function resetDesign(bForce)

    bForce = bForce or false

    if not pureConnect:isConnected() then
        pureConfigUI:setDesign(createPureNotSelectedUI, true)
    else
        pureConfigUI:setDesign(createPureConfigUI, true)
    end
    
    if bForce then
        pureConfigUI:resetDesign()
    else
        pureConfigUI:planDesignReset()
    end
    -- force a check of the script settings file in Pure wfx.
    -- It will call "script_settings_exist" or "script_settings_do_not_exist"
    --pureCustomScriptConnect:addCommand("SCRIPTcheck")
end

-- State connection from Pure wfx
pure_WFX_STATE = PureState:new(nil, true)

function PureConfig_getConnectConfigRoot()
    return pureConnectRoot
end

function PureConfig_getConnectTrack()
    return pureConnectTrack
end
--[[
local _l_pure_err_list = {}
function PURE_ERR_update()
    local header_txt = pureSTATE:getString("err.header")
    local msg_txt    = pureSTATE:getString("err.msg")
    
    if header_txt ~= "" and header_txt~=nil then
        local found = 0
        for i=1,#_l_pure_err_list do
            if _l_pure_err_list[i].header == header_txt then
                found = i
                break
            end
        end
        if found>0 then
            _l_pure_err_list[found].msg = msg_txt
        else
            table.insert(_l_pure_err_list,{header=header_txt, msg=msg_txt})
        end
    end
end
function PURE_ERR_show()

    local x = ui.getCursorX()
    local y = ui.getCursorY()

    for i=1,#_l_pure_err_list do
        ui.setCursorX(20)
        ui.setCursorY(340+40*(i-1))
        ui.text(_l_pure_err_list[i].header)

        ui.setCursorX(20)
        ui.setCursorY(360+40*(i-1))
        ui.text(_l_pure_err_list[i].msg)
    end
    
    ui.setCursorX(x)
    ui.setCursorY(y)
end
]]




-- provide this function for utilsLUT
function __PURE__sun_angle_get()
    local sun = pure_WFX_STATE:getValue("stellar.sun.angle")
    if sun then return sun end
    return 0
end


local _l_system_msg_types = { normal = 1, warning = 2, error = 3 }
local _l_system_msg = { msg = nil, msg_type = _l_system_msg_types.normal }
local _l_system_message_time = os.clock()






local function checkScriptDirty(reset)

    local ppPage = pureConfigUI:getPage("PP")
    if ppPage == nil then
        ppPage = pureConfigUI:getPage("PPoff")
    end
    if ppPage then
        local element
        for i=1,#ppPage.elements do
            element = ppPage.elements[i]
            if element then
                if element.customConnect == pureCustomScriptConnect then
                    if element.type == PURE_UI_TYPES.RADIO or element.type == PURE_UI_TYPES.SLIDER then
                        if reset then
                            if math.abs(element.value - element.origin) > 0.000001 then
                                gCustomScriptDirty_state = true
                                break
                            end
                        else
                            if math.abs(element.value - element.init) > 0.000001 then
                                gCustomScriptDirty_state = true
                                break
                            end
                        end
                    elseif element.type == PURE_UI_TYPES.CHECKBOX then
                        if reset then
                            if element.value ~= element.origin then
                                gCustomScriptDirty_state = true
                                break
                            end
                        else
                            if element.value ~= element.init then
                                gCustomScriptDirty_state = true
                                break
                            end
                        end
                    end
                end
            end
        end
    end
end


function manageDeletePPFilterRelatedButton(b)
    local page = pureConfigUI:getPage("PP")
    if page then
        local e = page:getFirstElement("SCRIPTdeletePPFILTERconfig", nil)
        if e then
            e.hidden = not b
        end
        e = page:getFirstElement("SCRIPTdeletePPFILTERconfig_text", nil)
        if e then
            e.hidden = b
        end
    end
end

function manageDeleteScriptSettingsButton(b)
    local page = pureConfigUI:getPage("PP")
    if page then
        local e = page:getFirstElement("SCRIPTdelete", nil)
        if e then
            e.hidden = not b
        end
        e = page:getFirstElement("SCRIPTload", nil)
        if e then
            e.hidden = not b
        end
        e = page:getFirstElement("SCRIPTdelete_text", nil)
        if e then
            e.hidden = b
        end
    end
end


function handleCommandFromPureWFX(cmd, value)

    if cmd == "system_warning" then
        _l_system_msg.msg = value
        _l_system_msg.msg_type = _l_system_msg_types.warning
        _l_system_message_time = os.clock()
    elseif cmd == "system_error" then
        _l_system_msg.msg = value
        _l_system_msg.msg_type = _l_system_msg_types.error
        _l_system_message_time = os.clock()
    elseif cmd == "system" then
        _l_system_msg.msg = value
        _l_system_msg.msg_type = _l_system_msg_types.normal
        _l_system_message_time = os.clock()

        -- check all custom script elements. If they differ from the saved value, set the state to dirty
        if  value == "Script settings reset to default" then
            checkScriptDirty(true)
        elseif value == "Script settings loaded" then
            gCustomScriptDirty_state = false
            checkScriptDirty(false)
        elseif value == "Script settings saved" then   
            gCustomScriptDirty_state = false
        elseif  value == "Custom track settings saved" or
                value == "Custom track settings loaded" or
                value == "Custom track settings deleted" or
                value == "Track settings from config loaded" or
                value == "Track settings resetted to defaults" then
            gCustomTrackDirty_state = false
        end
    elseif cmd == "ui" then
        if value == "ppfilter_config_exists" then
            manageDeletePPFilterRelatedButton(true)
        elseif value == "ppfilter_config_does_not_exists" then
            manageDeletePPFilterRelatedButton(false)
        elseif value == "script_settings_exist" then
            manageDeleteScriptSettingsButton(true)
        elseif value == "script_settings_do_not_exist" then
            manageDeleteScriptSettingsButton(false)
        end

    elseif cmd == "wfxreset" then
        resetDesign()
    end
end
pureConnect:setCommandHandler(handleCommandFromPureWFX)
--pureCustomScriptConnect:setCommandHandler(handleCommandFromPureWFX)
pureConnectTrack:setCommandHandler(handleCommandFromPureWFX)



function fullscreenUI()
    local uiState = ac.getUI()
end


-- PURE CHECKLIST -------------------------------------------------------------

local _l_VIDEO_INI_PARSE = ConfigParser:new()
local ini = ac.getFolder(ac.FolderID.Cfg) .. '\\video.ini'
local _l_sound_settings = false
function PureConfig_get_SoundSettings() return _l_sound_settings end
local _l_reflections_frequency = 0
local _l_reflectionsFX = 0
local _l_reflections_ibl = 0
local _l_reflections_car_cubemap = 0
function PureConfig_get_RefFreq() return _l_reflections_frequency end
function PureConfig_get_RefFX() return _l_reflectionsFX end
function PureConfig_get_RefIBL() return _l_reflections_ibl end
function PureConfig_get_RefCarCubemap() return _l_reflections_car_cubemap end
local _l_particlesFX = 0
function PureConfig_get_ParticlesFX() return _l_particlesFX end
local _l_clipplanes = 0
function PureConfig_get_ClipPlanes() return _l_clipplanes end
local _l_fxaa31 = false
function PureConfig_get_FXAA31() return _l_fxaa31 end
local _l_configschanges = 1
function PureConfig_get_ConfigChanges() return _l_configschanges end
local _l_wfxextraeffects = 1
function PureConfig_get_WfxExtraEffects() return _l_wfxextraeffects end
local _l_yebisest = 1
function PURE_CONFIG__get_YEBISSEST() return _l_yebisest end

if ac.getPatchVersionCode() >= 1881 then

    function PURE_CONFIG__initialize__CSP_SETTINGS_CHECK()

        if ac.INIConfig.videoConfig then
            local _l_AC_REFLECTIONS = ac.INIConfig.videoConfig()
            _l_reflections_frequency = _l_AC_REFLECTIONS:get("CUBEMAP","FACES_PER_FRAME", 0)
        else
            ac.log("CSP error".."...could not use CSP function to retrieve video settings!")

            if ini ~= nil and ini ~= "" then 
                if file_exists(ini) == true then 
                    _l_VIDEO_INI_PARSE:readFile(ini)
                    _l_reflections_frequency = _l_VIDEO_INI_PARSE:getValue("CUBEMAP", "FACES_PER_FRAME")
                    if _l_reflections_frequency ~= nil then
                        _l_reflections_frequency = _l_reflections_frequency[1]
                    else 
                        ac.log("Parse Error".."...could not parse reflections frequency")
                    end
                end
            end
        end

        function PURE_CONFIG__get_General_settings()
            local _l_CSP_MODUL_GENERAL = ac.INIConfig.cspModule(ac.CSPModuleID.General)
            _l_sound_settings = _l_CSP_MODUL_GENERAL:get("AUDIO", "DISTANCE_DELAY", 0)>0
        end
        PURE_CONFIG__get_General_settings()

        -- reflections settings
        function PURE_CONFIG__get_REFLECTIONS_settings()
            local _l_CSP_MODUL_REFLECTIONS = ac.INIConfig.cspModule(ac.CSPModuleID.ReflectionsFX)

            if ac.getPatchVersionCode() < 3465 then
                _l_reflectionsFX = _l_CSP_MODUL_REFLECTIONS:get("BASIC","ENABLED", 0)
            else
                _l_reflectionsFX = 1
            end
            
            if __CSP_version < 2902 then
                _l_reflections_ibl = _l_CSP_MODUL_REFLECTIONS:get("MAIN_CUBEMAP","USE_PROPER_IBL", 0)
            else
                _l_reflections_ibl = 1
            end
            _l_reflections_car_cubemap = _l_CSP_MODUL_REFLECTIONS:get("TWEAKS","CUBEMAP_FOR_FOCUSED_CAR", 0)
        end
        PURE_CONFIG__get_REFLECTIONS_settings()


        -- particles settings
        function PURE_CONFIG__get_PARTICLES_settings()
            local _l_CSP_MODUL_PARTICLES = ac.INIConfig.cspModule(ac.CSPModuleID.ParticlesFX)
            _l_particlesFX = _l_CSP_MODUL_PARTICLES:get("BASIC","ENABLED", 0)
        end
        PURE_CONFIG__get_PARTICLES_settings()


        -- Adaptive Clipplanes
        function PURE_CONFIG__get_CLIPPLANES_settings()
            local _l_CSP_MODUL_GRAPHICS = ac.INIConfig.cspModule(ac.CSPModuleID.GraphicsAdjustments)
            _l_clipplanes = _l_CSP_MODUL_GRAPHICS:get("ADAPTIVE_CLIP_PLANES","ENABLED",0)
            local farplanes = _l_CSP_MODUL_GRAPHICS:get("ADAPTIVE_CLIP_PLANES","FAR_PLANE",{20000, 30000})
            if farplanes then
                if farplanes[1]~=nil and farplanes[2]~=nil then
                    if tonumber(farplanes[1]) > 150000 or tonumber(farplanes[2]) > 150000 then
                        _l_clipplanes = 0
                    end
                    if tonumber(farplanes[1]) < 20000 and tonumber(farplanes[2]) < 30000 then
                        _l_clipplanes = 0
                    end
                    if tonumber(farplanes[1]) > tonumber(farplanes[2]) then
                        _l_clipplanes = 0
                    end
                else
                    _l_clipplanes = 0
                end
            end

            local nearplanes = _l_CSP_MODUL_GRAPHICS:get("ADAPTIVE_CLIP_PLANES","NEAR_PLANE",{0.1, 10})
            if nearplanes then
                if farplanes[1]~=nil and farplanes[2]~=nil then
                    if tonumber(nearplanes[1]) < 0.1 then
                        _l_clipplanes = 0
                    end
                else
                    _l_clipplanes = 0
                end
            end

            local active = _l_CSP_MODUL_GRAPHICS:get("BASIC","ENABLED", true)
            if not active then
                _l_clipplanes = 0
            end

            _l_fxaa31 = _l_CSP_MODUL_GRAPHICS:get("ANTIALIASING","MODE","") == "FXAA3"
        end
        PURE_CONFIG__get_CLIPPLANES_settings()

        -- Config Changes
        function PURE_CONFIG__get_CONFIGCHANGES_settings()
            local _l_CSP_MODUL_GENERAL = ac.INIConfig.cspModule(ac.CSPModuleID.General)
            _l_configschanges = _l_CSP_MODUL_GENERAL:get("CONFIGURATIONS","WATCH_FOR_CHANGES", 1)
        end
        PURE_CONFIG__get_CONFIGCHANGES_settings()

        -- WeatherFX Changes
        function PURE_CONFIG__get_WFX_settings()
            local _l_CSP_MODUL_GENERAL = ac.INIConfig.cspModule(ac.CSPModuleID.WeatherFX)
            _l_wfxextraeffects = _l_CSP_MODUL_GENERAL:get("PERFORMANCE","ADDITIONAL_EFFECTS", 1)
        end
        PURE_CONFIG__get_WFX_settings()

        -- Yebisest Changes
        function PURE_CONFIG__get_YEBISSEST_settings()
            local _l_CSP_MODUL_YEBISEST = ac.INIConfig.cspModule(ac.CSPModuleID.Yebisest)
            if _l_CSP_MODUL_YEBISEST then
                _l_yebisest = _l_CSP_MODUL_YEBISEST:get("BASIC","ENABLED", 1)
            end
        end
        PURE_CONFIG__get_YEBISSEST_settings()


        PureConfig_set_settings_watcher(pureConfigUI)
    end
    PURE_CONFIG__initialize__CSP_SETTINGS_CHECK()
else

    if ini ~= nil and ini ~= "" then 
        if file_exists(ini) == true then 
            _l_VIDEO_INI_PARSE:readFile(ini)
            _l_reflections_frequency = _l_VIDEO_INI_PARSE:getValue("CUBEMAP", "FACES_PER_FRAME")
            if _l_reflections_frequency ~= nil then
                _l_reflections_frequency = _l_reflections_frequency[1]
            else 
                ac.log("Parse Error".."...could not parse reflections frequency")
            end
        end
    end


    local _l_REFLECTIONS_INI_PARSE = ConfigParser:new()
    local _l_REFLECTIONS_INI_PARSE2 = ConfigParser:new()
    ini = ac.getFolder(ac.FolderID.Cfg)..'\\extension\\reflections_fx.ini'
    ini2 = ac.getFolder(ac.FolderID.ExtRoot)..'\\config\\reflections_fx.ini'
        
    if ini ~= nil and ini ~= "" then 
        if file_exists(ini) == true then _l_REFLECTIONS_INI_PARSE:readFile(ini) end
    end
    if ini2 ~= nil and ini2 ~= "" then
        if file_exists(ini2) == true then _l_REFLECTIONS_INI_PARSE2:readFile(ini2) end
    end

    _l_reflectionsFX = _l_REFLECTIONS_INI_PARSE:getValue("BASIC", "ENABLED")
    if _l_reflectionsFX ~= nil then
        _l_reflectionsFX   = _l_reflectionsFX[1]
    else
        _l_reflectionsFX = _l_REFLECTIONS_INI_PARSE2:getValue("BASIC", "ENABLED")
        if _l_reflectionsFX ~= nil then
            _l_reflectionsFX   = _l_reflectionsFX[1]
        else
            ac.log("Parse Error".."...could not parse reflectionsFX enabled")
        end
    end

    _l_reflections_ibl = _l_REFLECTIONS_INI_PARSE:getValue("MAIN_CUBEMAP", "USE_PROPER_IBL")
    if _l_reflections_ibl ~= nil then
        _l_reflections_ibl   = _l_reflections_ibl[1]
    else
        _l_reflections_ibl = _l_REFLECTIONS_INI_PARSE2:getValue("MAIN_CUBEMAP", "USE_PROPER_IBL")
        if _l_reflections_ibl ~= nil then
            _l_reflections_ibl   = _l_reflections_ibl[1]
        else
            ac.log("Parse Error".."...could not parse reflectionsFX IBL")
        end
    end

    _l_reflections_car_cubemap = _l_REFLECTIONS_INI_PARSE:getValue("TWEAKS", "CUBEMAP_FOR_FOCUSED_CAR")
    if _l_reflections_car_cubemap ~= nil then
        _l_reflections_car_cubemap   = _l_reflections_car_cubemap[1]
    else
        _l_reflections_car_cubemap = _l_REFLECTIONS_INI_PARSE2:getValue("TWEAKS", "CUBEMAP_FOR_FOCUSED_CAR")
        if _l_reflections_car_cubemap ~= nil then
            _l_reflections_car_cubemap   = _l_reflections_car_cubemap[1]
        else
            ac.log("Parse Error".."...could not parse reflectionsFX Tweaks Car Cubemap")
        end
    end
end
----------------------------------------------------------------------------------------------------






local function Main()
    --[[]
    ui.text('TAB 1')
    ui.text('physics late: '..ac.getSim().physicsLate)
    ui.text('CPU occupancy: '..ac.getSim().cpuOccupancy)
    ui.text('CPU time: '..ac.getSim().cpuTime)
    ]]
    --ui.text(string.format('Pure config v%.2f, Parameters: %.0f, CSP: %s', version, pureConfigUI.connectCount, ac.getPatchVersion()))
    --ui.separator()
end

--[[
local function handleCheckbox(e)
end
pureConfigUI:setCheckboxHandler(handleCheckbox)

local function handleSlider(e)
end
pureConfigUI:setSliderHandler(handleSlider)
]]
local _l_current_tab = ""
local function handleTabbar(e)
    if e then
        _l_current_tab = e.name
    end
end
pureConfigUI:setTabbarHandler(handleTabbar)





local _l_file_dialog_return = nil
local _l_bFileDialogRunning = false
local _l_PostFileDialogHandler = nil

function PureConfig__export(file)
    pureConnect:addCommand("Export", file)
end
function PureConfig__import(file)
    pureConnect:addCommand("Import", file)
end
function PureCustomConfig__deleteScriptSettings(bDelete)
    if bDelete then
        --pureCustomScriptConnect:addCommand("SCRIPTdelete")
    end
end
function PureCustomConfig__deletePPfilterConfig(bDelete)
    if bDelete then
        pureConnect:addCommand("SCRIPTdeletePPFILTERconfig")
    end
end

local fileDialog = PureUI_FileDialog(__pureConfig_path)
fileDialog:addFavoriteFolder("Config dir", _l_config_path)
fileDialog:addFavoriteFolder("Documents", ac.getFolder(ac.FolderID.Cfg).."\\")
fileDialog:initFileDialog(_l_config_path, "ini", "Export Pure Config File")






local _l_CSP_MODUL_WEATHERFX = ac.INIConfig.cspModule(ac.CSPModuleID.WeatherFX)
local function handleButton(e)
    if  e.section=="resetToDefaults" or 
        e.section=="resetPure" or
        e.section=="saveTrackSpecific" or
        e.section=="loadTrackSpecific" or
        e.section=="deleteTrackSpecific" or
        e.section=="SCRIPTexportPPFILTERconfig" or
        e.section=="qualityLOW" or
        e.section=="qualityMEDIUM" or
        e.section=="qualityHIGH" or
        e.section=="qualityVERYHIGH" then
        pureConnect:addCommand(e.section)
    --elseif  e.section=="SCRIPTresetToDefaults" or
    --        e.section=="SCRIPTload" or
    --        e.section=="SCRIPTsave"then
    --    pureCustomScriptConnect:addCommand(e.section)
    --elseif  e.section=="SCRIPTdelete" then
    --    fileDialog:startConfirmDialog(PureCustomConfig__deleteScriptSettings, "Delete the script settings file?")
    elseif  e.section=="SCRIPTdeletePPFILTERconfig" then
        fileDialog:startConfirmDialog(PureCustomConfig__deletePPfilterConfig, "Delete the PPfilter related config file?")
    elseif  e.section=="TRACKsaveCustom" or
            e.section=="TRACKloadCustom" or
            e.section=="TRACKloadConfig" or
            e.section=="TRACKresetToDefaults" or
            e.section=="TRACKdeleteCustom" or
            e.section=="TRACKexportConfigClipboard" or 
            e.section=="TRACKexportConfigClipboard__INTERNAL" then
        pureConnectTrack:addCommand(e.section)
    elseif  e.section=="activatePureWeatherScript" then
        --local _l_CSP_MODUL_WEATHERFX = ac.INIConfig.cspModule(ac.CSPModuleID.WeatherFX)
        _l_CSP_MODUL_WEATHERFX.format = ac.INIFormat.Default
        -- set a fake value to trigger saving twice. It will not save it, if "pure" was already selected.
        _l_CSP_MODUL_WEATHERFX:setAndSave("BASIC", "IMPLEMENTATION", "fake")
        _l_CSP_MODUL_WEATHERFX:setAndSave("BASIC", "IMPLEMENTATION", "Pure LCS")
    elseif  e.section=="fixWrongSettings" then
        if ac.getPatchVersionCode() >= 1881 then
            --[[
            local _l_CSP_MODUL_REFLECTIONS = ac.INIConfig.cspModule(ac.CSPModuleID.ReflectionsFX)
            if _l_reflectionsFX < 1 then
                _l_CSP_MODUL_REFLECTIONS:set("BASIC","ENABLED", 1)
            end
            if _l_reflections_ibl < 1 then
                _l_CSP_MODUL_REFLECTIONS:set("MAIN_CUBEMAP","USE_PROPER_IBL", 1)
            end
            if _l_reflections_car_cubemap > 0 then
                _l_CSP_MODUL_REFLECTIONS:set("TWEAKS","CUBEMAP_FOR_FOCUSED_CAR", 0)
            end
            _l_CSP_MODUL_REFLECTIONS:save()

            local _l_CSP_MODUL_PARTICLES = ac.INIConfig.cspModule(ac.CSPModuleID.ParticlesFX)
            if _l_particlesFX < 1 then
                _l_CSP_MODUL_PARTICLES:set("BASIC","ENABLED", 1)
                _l_CSP_MODUL_PARTICLES:save()
            end

            local _l_CSP_MODUL_GRAPHICS = ac.INIConfig.cspModule(ac.CSPModuleID.GraphicsAdjustments)
            if _l_clipplanes < 1 then
                _l_CSP_MODUL_GRAPHICS:set("ADAPTIVE_CLIP_PLANES","ENABLED", 1)
                _l_CSP_MODUL_GRAPHICS:set("ADAPTIVE_CLIP_PLANES","FAR_PLANE", {20000, 30000})
                _l_CSP_MODUL_GRAPHICS:save()
            end
            ]]
            PureConfig_Fix_Wrong_Settings(pureConfigUI, pureConnect)

            -- remove this later if ac.onCSPConfigChanged() works again
            if __CSP_version < 2472 then --0.1.80p317
                PURE_CONFIG__get_REFLECTIONS_settings()
                PURE_CONFIG__get_PARTICLES_settings()
                PURE_CONFIG__get_CLIPPLANES_settings()
            end
            pureConfigUI:resetDesign()
        end
    end
end
pureConfigUI:setButtonHandler(handleButton) 

local function handleCheckbox(e)
    if e.section == "ppTonemapUtils" and e.key == "debug_curve" then
        e.page.ui:resetDesign()
    end
end
pureConfigUI:setCheckboxHandler(handleCheckbox) 


pureConfigUI:setInfoHandler(PureConfigInfoHandler)  

local _l_PureVersion = 0.00
local _l_main_info = ""
local _l_main_info_update = os.clock()

local _l_pp_activated = true
function PureConfig_PPactivated()
    return _l_pp_activated
end

function update_main_info()
    _l_PureVersion = pureConnect:getWFXVersion()
    local n_parameters = pureConnect:getParameterCount()
    _l_main_info = string.format('v%.2f, n: %.0f, CSP: %s, %s: %.2f', __PureConfig_version, n_parameters, ac.getPatchVersion(), style, _l_PureVersion)
end
update_main_info()




local _l_outline_color = rgbm(1, 0, 0, 1)
local _l_main_vec2 = vec2(0,0)
local _l_main_scale = vec2(0,0)
local _l_Bottom = 30
local _l_Top = 14
local _l_Scale = 1.0

local _l_c_grey = rgbm(1,1,1,0.5)
local _l_item_back = rgbm(0,0,0,0.50)
local _l_c_green = rgbm(0.25,1,0.25,1)
local _l_c_orange = rgbm(1,0.5,0.0,1)
local _l_c_red = rgbm(1,0,0,1)
local _l_c_dirty = rgbm(0.5,0.45,0.2,1)

local _l_dirty = false
--[[
for k,v in pairs(ac) do
    if type(v) == "cdata" then
        ac.debug("##"..k, type(v))
    end
end
]]

local function save_ppfilter_related_config(confirm)
    if confirm then
        pureConnect:addCommand("Save")
        -- also save the scipt settings
        --pureCustomScriptConnect:addCommand("SCRIPTsave")
    end
end


local _l_CSP_do_shaders = (__CSP_version >= 2051) -- CSP 1.78
local _l_button_framing = vec2(1,1)

local _l_txt_save = "SAVE"
local _l_txt_save_script = "SAVE config\n+ script set."

local _l_txt_load = "LOAD"
local _l_txt_load_script = "LOAD config\n+ script set."

local _l_tmp_vec = vec2()
local _l_button_reset = vec2(31,21)
local _l_pure_active = true

function Main(dt)

    -- get the pilot tone from Pure. It will tell if it is still running
    if os.clock() >= _l_PURE_PILOT_TONE_update + 1 then
        _l_PURE_PILOT_TONE_update = os.clock()
      
        _l_PURE_PILOT_TONE:Restore()
        local tmp = tonumber(_l_PURE_PILOT_TONE:get("time") or 0)
        
        if math.abs(tmp - _l_PURE_PILOT_TONE_update) > 2 then

            if pureConnect:isConnected() then
                pureConnect:disconnect()
            end
            if pureConnectRoot:isConnected() then
                pureConnectRoot:disconnect()
            end
            --if pureCustomScriptConnect:isConnected() then
            --    pureCustomScriptConnect:disconnect()
            --end
            if pureConnectTrack:isConnected() then
                pureConnectTrack:disconnect()
            end
            --if pure_WFX_STATE:isConnected() then
            --    pure_WFX_STATE:disconnect()
            --end

            if _l_pure_active then
                pureConfigUI:resetDesign()
            end

            _l_pure_active = false
        else
            _l_pure_active = true
        end
    end

    ui.pushStyleColor(ui.StyleColor.FrameBg, _l_item_back)

    --_l_tmp_vec:set(ui.availableSpace())
    --if style_mode == 1 then
    --    UI_gl_rect_filled(21, 10, _l_tmp_vec.x+20, 25, rgbm.colors.blue)
    --else
    --    UI_gl_rect_filled(21, 10, _l_tmp_vec.x+20, 25, rgbm.colors.orange)
    --end


    if fileDialog.running then
        fileDialog:FileDialog()
    else

        local x_safe = ui.getCursorX()
        local y_safe = ui.getCursorY()
        ui.setCursorX(20)
        ui.setCursorY(6)
        if ui.iconButton(ui.Icons.Reset, _l_button_reset) then
            pureConnect:addCommand("resetPure")
        end
        if ui.itemHovered() then
            ui.setTooltip("Restart the weatherFX system")
        end
        ui.setCursorX(x_safe + 40)
        ui.setCursorY(y_safe)

        local pp_tmp = pure_WFX_STATE:getValue("PP.active")
        if pp_tmp ~= _l_pp_activated then
            _l_pp_activated = pp_tmp
            resetDesign(true)
        end

        local actT = os.clock()
        if actT-_l_main_info_update > 1 then
            update_main_info()
        end
        if actT-_l_system_message_time > 5 then
            _l_system_msg.msg = nil
        end
    
        if _l_system_msg.msg then
            if _l_system_msg.msg_type == _l_system_msg_types.normal then
                ui.textColored(_l_system_msg.msg, _l_c_green)
            elseif _l_system_msg.msg_type == _l_system_msg_types.warning then
                ui.textColored(_l_system_msg.msg, _l_c_orange)
            elseif _l_system_msg.msg_type == _l_system_msg_types.error then
                ui.textColored(_l_system_msg.msg, _l_c_red)
            end
        else
            local color = _l_c_grey
            if style_mode == 1 then
                color = rgbm.colors.aqua
            elseif style_mode == 2 then
                color = rgbm.colors.orange
            end
            ui.textColored(_l_main_info, color)
        end
        ui.separator()

        
        pureConfigUI:setSize(
            ui.availableSpaceX(),
            (ui.availableSpaceY() - (_l_Bottom + _l_Top))
        )

        local _l_current_tab = pureConfigUI:renderTabbar("Main", 0, 0)
        
--[[
        PURE_ERR_update()
        PURE_ERR_show()
]]

        ui.separator()
        
        if _l_current_tab ~= "Track" and _l_current_tab ~= "Consent" then
            
            ui.columns(4, true, nil)
            ui.pushStyleVar(ui.StyleVar.FramePadding, _l_button_framing)

            _l_main_vec2.x, _l_main_vec2.y = ui.availableSpaceX(), _l_Bottom
            if _l_dirty then 
                ui.pushStyleColor(ui.StyleColor.Button, _l_c_dirty)
            end
--[[
            local tmp_txt = _l_txt_save
            if _l_current_tab == "PP" then
                tmp_txt = _l_txt_save_script
            end
]]            
            if ui.button(_l_txt_save, _l_main_vec2, 0) then

                local file = pure_WFX_STATE:getString("config.ppfilterrelatedfile")
                if file~=nil and file~="" then
                    -- ppfilter related config file is used
                    fileDialog:startConfirmDialog(save_ppfilter_related_config, "The current ppfilter is using its own Pure config!\nYour changes will be written in this config!\n\nAre you sure, you want to overwrite this file?")
                else
                    --if _l_current_tab == "PP" then
                    --    pureCustomScriptConnect:addCommand("SCRIPTsave")
                    --end
                    pureConnect:addCommand("Save")
                end
                pureConfigUI:setDirty(false)
            end
            if _l_dirty then 
                ui.popStyleColor(1)
            end

            ui.nextColumn()

--[[
            tmp_txt = _l_txt_load
            if _l_current_tab == "PP" then
                tmp_txt = _l_txt_load_script
            end
]]
            if ui.button(_l_txt_load, _l_main_vec2, 0) then
                --if _l_current_tab == "PP" then
                --    pureCustomScriptConnect:addCommand("SCRIPTload")
                --end
                pureConnect:addCommand("Load")
                pureConfigUI:setDirty(false)
            end
            ui.nextColumn()
            if ui.button("EXPORT", _l_main_vec2, 0) then
                fileDialog:startFileDialog(PureConfig__export, "Export Pure Config File", nil, "ini", true)
                --os.openFileDialog({ title = 'Open', defaultFolder = ac.getFolder(ac.FolderID.Root), nil, nil, { { name = 'Configs', mask = 'ini' } }, true, 1, nil, nil, { }, bit.bor(os.DialogFlags.PathMustExist, os.DialogFlags.FileMustExist) }, fun)
            end
            ui.nextColumn()
            if ui.button("IMPORT", _l_main_vec2, 0) then
                fileDialog:startFileDialog(PureConfig__import, "Import Pure Config File", nil, "ini")
            end

            ui.popStyleVar(1)

            ui.columns(1, false, nil)
        end

        pureConfigUI:update(dt)
        if _l_dirty ~= pureConfigUI:isDirty() then
            _l_dirty = pureConfigUI:isDirty()
        end
    end

    
    ui.popStyleColor(1)
end

local _l_size = vec2(100,100)
local _l_mouse_on_app = false
function PureConfig_mouse_is_on_app()
    return _l_mouse_on_app
end

function windowMain(dt)

    _l_size.x = ui.availableSpaceX() + 60
    _l_size.y = ui.availableSpaceY() + 15

    ui.setCursorX(-10)
    ui.setCursorY(15)

    ui.childWindow("Main", _l_size, true, 224, function() Main(dt) end)
    _l_mouse_on_app = ui.itemHovered() or ui.windowHovered()

    --runGC()
    --printGC()
end



--[[]]
function windowMainSettings(dt)
    showPureConfigInfo()
end


function windowMainIcon(dt)
    
end

local last_CPL = -1
local replay_active = false
local headlight_automatic = false

function PURE_CONFIG__get_HeadlightsControl() return headlight_automatic end
function PURE_CONFIG__check_HeadlightsControl()
    local _l_CSP_MODUL_WEATHERFX = ac.INIConfig.cspModule(ac.CSPModuleID.WeatherFX)
    headlight_automatic = (_l_CSP_MODUL_WEATHERFX:get("MISCELLANEOUS","SWITCH_HEADLIGHTS_WITH_AI", 0) > 0) and true or false
end
PURE_CONFIG__check_HeadlightsControl()

local function check_weatherFX_config_change()
    PURE_CONFIG__check_HeadlightsControl()
    pureConfigUI:planDesignReset()
end
ac.onCSPConfigChanged(ac.CSPModuleID.WeatherFX, check_weatherFX_config_change)


local headlights_forced_outside = false
function PURE_CONFIG__reset_HL_force_outside() headlights_forced_outside = false end
local highbeams_forced_outside = false
function PURE_CONFIG__reset_HB_force_outside() highbeams_forced_outside = false end
local last_headlights = nil
local last_highbeams = nil

function PURE_CONFIG__replay_active() return replay_active end
local headlights = ac.SceneTweakFlag.Default
local high_beams = ac.SceneTweakFlag.Default
function PURE_CONFIG__get_cars_headlights() return headlights end
function PURE_CONFIG__set_cars_headlights(v)
    if v~=headlights then
        pureConfigUI:setDirty(true)
    end
    headlights = v
    local tmp_headlights = pureConnect:getIDByName("AI_headlights.headlights_ctrl")
    if tmp_headlights~=nil then
        pureConnect:init(tmp_headlights+1, headlights)
    end
    PURE_CONFIG__reset_HL_force_outside()
end
function PURE_CONFIG__get_cars_high_beams() return high_beams end
function PURE_CONFIG__set_cars_high_beams(v)
    if v~=high_beams then
        pureConfigUI:setDirty(true)
    end
    high_beams = v
    local tmp_high_beams = pureConnect:getIDByName("AI_headlights.high_beams_ctrl")
    if tmp_high_beams~=nil then
        pureConnect:init(tmp_high_beams+1, high_beams)
    end
    PURE_CONFIG__reset_HB_force_outside()
end


local states_early_load = false

local all_connections = false
local function check_connection_complete()
    if  pureConnectRoot:isConnected() and
        pureConnect:isConnected() and
        pure_WFX_STATE:isConnected() and
        pureConnectTrack:isConnected() then
        
        all_connections = true

        resetDesign()
    else
        all_connections = false
    end
end

function script.update(dt)

    if pureConnectRoot:checkInterface() then
        --dev_dbg("# Root connect", "connected, "..pureConnectRoot:getParameterCount())
        check_connection_complete()
    end
    if pureConnect:checkInterface() then
        -- if a new connect struct was received, reset the design
        update_main_info()

        local tmp_headlights = pureConnect:getByName("AI_headlights.headlights_ctrl")
        if tmp_headlights~=nil then
            PURE_CONFIG__set_cars_headlights(tmp_headlights)
        end
        tmp_headlights = pureConnect:getByName("AI_headlights.high_beams_ctrl")
        if tmp_headlights~=nil then
            PURE_CONFIG__set_cars_high_beams(tmp_headlights)
        end

        check_connection_complete()
        --dev_dbg("# Pure connect", "connected, "..pureConnect:getParameterCount())
    end
    if pure_WFX_STATE:checkInterface() then
        -- set the state obj to retrieve Pure status data
        pureConfigUI:setStateObj(pure_WFX_STATE)
        
        check_connection_complete()
        --dev_dbg("# WFX States connect", "connected, "..(#pure_WFX_STATE:getParameterList()))
    end
    if pureConnectTrack:checkInterface() then
        
        check_connection_complete()
        --dev_dbg("# Track connect", "connected, "..pureConnectTrack:getParameterCount())
    end
    --if pureCustomScriptConnect:checkInterface() and pureConnect:isConnected() then
    --    -- if the interface was changed or initialized, refresh the design
    --    gCustomScriptDirty_state = false
    --    resetDesign()
    --end


    if pure_WFX_STATE:isConnected() then

        PURE_CONFIG__set_quality_setting((pure_WFX_STATE:getValue("settings.quality")))
        
        local CPL_intensity = pure_WFX_STATE:getValue("CPL.intensity")
        if CPL_intensity >= 0 then
            ac.setCameraCPLSettings(CPL_intensity,
                                    pure_WFX_STATE:getValue("CPL.rotation"),
                                    pure_WFX_STATE:getValue("CPL.offset"),
                                    pure_WFX_STATE:getValue("CPL.photo"))
            last_CPL = CPL_intensity
        else
            if last_CPL >= 0 then
                -- reset CPL, so it is adjustable in the PhotoMode app again
                ac.setCameraCPLSettings(nil,nil,nil,nil)
            end
            last_CPL = -1
        end

        local sim = ac.getSim()
        if sim~=nil then
            
            if PURE_CONFIG__get_HeadlightsControl() then

                if sim.isReplayActive ~= replay_active then
                    if not sim.isReplayActive and headlights<100 then
                        headlights = ac.SceneTweakFlag.Default
                    end
                    replay_active = sim.isReplayActive
                end

                if last_headlights~=nil and ac.configureSceneTweaks().forceHeadlights~=last_headlights then
                    headlights_forced_outside = true
                end
                
                if not headlights_forced_outside then

                    if replay_active or headlights>=100 then

                        if headlights == ac.SceneTweakFlag.Default or headlights>=100 then
                            if pure_WFX_STATE:getValue("ai.headlights") then
                                ac.configureSceneTweaks().forceHeadlights = ac.SceneTweakFlag.ForceOn
                            else
                                ac.configureSceneTweaks().forceHeadlights = ac.SceneTweakFlag.ForceOff
                            end
                        else
                            ac.configureSceneTweaks().forceHeadlights = headlights
                        end
                    else
                        ac.configureSceneTweaks().forceHeadlights = headlights
                    end
                else
                    headlights = ac.configureSceneTweaks().forceHeadlights
                    if headlights==ac.SceneTweakFlag.Default then
                        headlights_forced_outside = false
                    end
                end
                

                if last_highbeams~=nil and ac.configureSceneTweaks().forceHighBeams~=last_highbeams then
                    highbeams_forced_outside = true
                end
                if not highbeams_forced_outside then
                    ac.configureSceneTweaks().forceHighBeams = high_beams
                else
                    high_beams = ac.configureSceneTweaks().forceHighBeams
                    if high_beams==ac.SceneTweakFlag.Default then
                        highbeams_forced_outside = false
                    end
                end

                last_headlights = ac.configureSceneTweaks().forceHeadlights
                last_highbeams = ac.configureSceneTweaks().forceHighBeams
            end
        end
    end
end

local _l_spline = ac.hasTrackSpline()
local _l_edit_track_spline = false
function PureConfig_setTrackSplineEditing(b)
    _l_edit_track_spline = b
end


function script.draw3D()
    if _l_spline and _l_edit_track_spline and _l_current_tab=="Track" then
        Update_groundfog_spline_distances(dt)
        Update_groundfog_graphics(dt)
    end
end




